/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.internal.core.github;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.github.IGithubManager;
import com.aptana.git.core.github.IGithubRepository;
import com.aptana.git.core.github.IGithubUser;
import com.aptana.git.internal.core.github.GithubAPI;
import com.aptana.git.internal.core.github.GithubRepository;
import com.aptana.git.internal.core.github.GithubUser;
import com.aptana.git.internal.core.github.Messages;
import java.net.HttpURLConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.json.simple.JSONObject;

public class GithubManager
implements IGithubManager {
    private static final String USERNAME_PROPERTY = "login";
    private static final String SECURE_PREF_NODE = "com.aptana.git.core";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private IGithubUser fUser;

    public GithubManager() {
        this.loadCredentials();
    }

    public IGithubUser getUser() {
        return this.fUser;
    }

    public IStatus login(String username, String password) {
        HttpURLConnection connection = null;
        try {
            JSONObject result = (JSONObject)this.getAPI(new GithubUser(username, password)).get("user");
            String actualUsername = (String)result.get((Object)USERNAME_PROPERTY);
            this.fUser = new GithubUser(actualUsername, password);
            this.saveCredentials();
            Status status = new Status(0, SECURE_PREF_NODE, 0, null, null);
            return status;
        }
        catch (CoreException ce) {
            IStatus iStatus = ce.getStatus();
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, SECURE_PREF_NODE, -1, null, (Throwable)e);
            return status;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public IStatus logout() {
        ISecurePreferences prefs = this.getSecurePreferences();
        try {
            prefs.remove(USERNAME);
            prefs.remove(PASSWORD);
            prefs.flush();
            this.fUser = null;
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, SECURE_PREF_NODE, -1, Messages.GithubManager_LogoutFailed, (Throwable)e);
        }
    }

    private void loadCredentials() {
        ISecurePreferences prefs = this.getSecurePreferences();
        try {
            String username = prefs.get(USERNAME, null);
            String password = prefs.get(PASSWORD, null);
            if (!StringUtil.isEmpty((String)username) && !StringUtil.isEmpty((String)password)) {
                this.fUser = new GithubUser(username, password);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (String)"Failed to load Github user credentials", (Throwable)e);
        }
    }

    private void saveCredentials() throws CoreException {
        ISecurePreferences prefs = this.getSecurePreferences();
        try {
            prefs.put(USERNAME, this.fUser.getUsername(), true);
            prefs.put(PASSWORD, this.fUser.getPassword(), true);
            prefs.flush();
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, SECURE_PREF_NODE, -1, Messages.GithubManager_CredentialSaveFailed, (Throwable)e));
        }
    }

    protected ISecurePreferences getSecurePreferences() {
        return SecurePreferencesFactory.getDefault().node(SECURE_PREF_NODE);
    }

    public IGithubRepository getRepo(String owner, String repoName) throws CoreException {
        if (this.fUser == null) {
            throw new CoreException((IStatus)new Status(4, SECURE_PREF_NODE, 1234, Messages.GithubManager_ERR_Github_NotLoggedIn, null));
        }
        JSONObject result = (JSONObject)this.getAPI(this.fUser).get("repos/" + owner + '/' + repoName);
        return new GithubRepository(result);
    }

    public IGithubRepository fork(String owner, String repoName, String destination) throws CoreException {
        if (this.fUser == null) {
            throw new CoreException((IStatus)new Status(4, SECURE_PREF_NODE, 1234, Messages.GithubManager_ERR_Github_NotLoggedIn, null));
        }
        String data = null;
        if (destination != null) {
            data = "{organization: \"" + destination + "\"}";
        }
        JSONObject result = (JSONObject)this.getAPI(this.fUser).post("repos/" + owner + '/' + repoName + "/forks", data);
        return new GithubRepository(result);
    }

    protected GithubAPI getAPI(IGithubUser user) {
        return new GithubAPI(user);
    }
}

